/* Cockos SWELL (Simple/Small Win32 Emulation Layer for Losers (who use OS X))
   Copyright (C) 2006-2007, Cockos, Inc.

    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
  

    SWELL provides _EXTREMELY BASIC_ win32 wrapping for OS X. It is far from complete, too.

  */


#ifndef _WIN32


#ifndef _WDL_SWELL_H_ // here purely for apps/other libraries (dirscan.h uses it), each section actually has its own define
#define _WDL_SWELL_H_


#ifdef __APPLE__
#define SWELL_TARGET_OSX
#define SWELL_TARGET_OSX_COCOA
#endif

// for swell*generic
// #define SWELL_TARGET_GDK
// #define SWELL_LICE_GDI

#endif


// IF YOU ADD TO SWELL:
// Adding types, defines, etc: put them in _WDL_SWELL_H_TYPES_DEFINED_ block.
// Adding functions: put them in _WDL_SWELL_H_API_DEFINED_ block!
//   when adding APIs, add it using:
//      SWELL_API_DEFINE(void, function_name, (int parm, int parm2))
//   rather than:
//      void function_name(int parm, int parm2);



////////////////// SWELL INCLUDES, DEFINES AND TYPEDEFS


#ifndef _WDL_SWELL_H_TYPES_DEFINED_
#define _WDL_SWELL_H_TYPES_DEFINED_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dlfcn.h>
#include <ctype.h>


#include <stdint.h>
typedef intptr_t INT_PTR, *PINT_PTR, LONG_PTR, *PLONG_PTR;
typedef uintptr_t UINT_PTR, *PUINT_PTR, ULONG_PTR, *PULONG_PTR, DWORD_PTR, *PDWORD_PTR;

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef max
#define max(x,y) ((x)<(y)?(y):(x))
#define min(x,y) ((x)<(y)?(x):(y))
#endif

#ifndef S_OK
#define S_OK 0
#endif
#ifndef E_FAIL
#define E_FAIL (-1)
#endif


// the byte ordering of RGB() etc is different than on win32 
#define RGB(r,g,b) (((r)<<16)|((g)<<8)|(b))
#define GetRValue(x) (((x)>>16)&0xff)
#define GetGValue(x) (((x)>>8)&0xff)
#define GetBValue(x) ((x)&0xff)

// basic platform compat defines
#define stricmp(x,y) strcasecmp(x,y)
#define strnicmp(x,y,z) strncasecmp(x,y,z)

#define DeleteFile(x) (!unlink(x))
#define MoveFile(x,y) (!rename(x,y))
#define GetCurrentDirectory(sz,buf) (!getcwd(buf,sz))
#define SetCurrentDirectory(buf) (!chdir(buf))
#define CreateDirectory(x,y) (!mkdir((x),0755))
#define wsprintf sprintf

#ifndef LOWORD
#define MAKEWORD(a, b)      ((unsigned short)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))
#define MAKELONG(a, b)      ((long)(((unsigned short)(a)) | ((DWORD)((unsigned short)(b))) << 16))
#define MAKEWPARAM(l, h)      (WPARAM)MAKELONG(l, h)
#define MAKELPARAM(l, h)      (LPARAM)MAKELONG(l, h)
#define MAKELRESULT(l, h)     (LRESULT)MAKELONG(l, h)
#define LOWORD(l)           ((unsigned short)(l))
#define HIWORD(l)           ((unsigned short)(((unsigned int)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((unsigned short)(w) >> 8) & 0xFF))
#endif

#define GET_X_LPARAM(lp)                        ((int)(short)LOWORD(lp))
#define GET_Y_LPARAM(lp)                        ((int)(short)HIWORD(lp))

#define UNREFERENCED_PARAMETER(P) (P)
#define _T(T) T

#define CallWindowProc(A,B,C,D,E) ((WNDPROC)A)(B,C,D,E)
#define OffsetRect WinOffsetRect  //to avoid OSX's OffsetRect function
#define SetRect WinSetRect        //to avoid OSX's SetRect function
#define UnionRect WinUnionRect  
#define IntersectRect WinIntersectRect


#define MAX_PATH 1024



// SWELLAPP stuff (swellappmain.mm)
INT_PTR SWELLAppMain(int msg, INT_PTR parm1, INT_PTR parm2); // to be implemented by app (if using swellappmain.mm)
#define SWELLAPP_ONLOAD 0x0001 // initialization of app vars etc
#define SWELLAPP_LOADED 0x0002 // create dialogs etc
#define SWELLAPP_DESTROY 0x0003 // about to destroy (cleanup etc)
#define SWELLAPP_SHOULDDESTROY 0x0004 // return 0 to allow app to terminate, >0 to prevent

#define SWELLAPP_OPENFILE 0x0050 // parm1= (const char *)string, return >0 if allowed
#define SWELLAPP_NEWFILE 0x0051 // new file, return >0 if allowed
#define SWELLAPP_SHOULDOPENNEWFILE 0x0052 // allow opening new file? >0 if allowed

#define SWELLAPP_ONCOMMAND 0x0099 // parm1 = (int) command ID, parm2 = (id) sender 
#define SWELLAPP_PROCESSMESSAGE 0x0100 // parm1=(MSG *)msg (loosely), parm2= (NSEvent *) the event . return >0 to eat

#define SWELLAPP_ACTIVATE 0x1000  // parm1 = (bool) isactive. return nonzero to prevent WM_ACTIVATEAPP from being broadcasted
//




// basic types
typedef signed char BOOL;
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned int DWORD;
typedef DWORD COLORREF;
typedef unsigned int UINT;
typedef int INT;

typedef ULONG_PTR WPARAM;
typedef LONG_PTR LPARAM;
typedef LONG_PTR LRESULT;


typedef void *LPVOID, *PVOID;
typedef int HRESULT;
typedef short SHORT;
typedef unsigned int ULONG;
typedef int LONG;
typedef int *LPINT;
typedef char CHAR;
typedef char *LPSTR;
typedef const char *LPCSTR;

#define __int64 long long // define rather than typedef, for unsigned __int64 support

typedef unsigned __int64 ULONGLONG;

typedef union { 
  unsigned long long QuadPart; 
  struct {
  #ifdef __ppc__
    DWORD HighPart;
    DWORD LowPart;
  #else
    DWORD LowPart;
    DWORD HighPart;
  #endif
  };
} ULARGE_INTEGER;


typedef struct HWND__ *HWND;
typedef struct HMENU__ *HMENU;
typedef void *HANDLE, *HINSTANCE, *HDROP, *HGLOBAL;

typedef void (*TIMERPROC)(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime);

typedef struct 
{
  LONG x,y;
} POINT, *LPPOINT;


typedef struct
{
  SHORT x;
  SHORT y;
} POINTS;


typedef struct 
{
  LONG left,top, right, bottom;
} RECT, *LPRECT;


typedef struct {
  unsigned char fVirt;
  unsigned short key,cmd;
} ACCEL, *LPACCEL;


typedef struct {
  DWORD dwLowDateTime;
  DWORD dwHighDateTime;
} FILETIME;

typedef struct _GUID {
  unsigned int Data1;
  unsigned short Data2;
  unsigned short Data3;
  unsigned char  Data4[8];
} GUID;

typedef struct {
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *LPMSG;

typedef void *HDC, *HBRUSH, *HPEN, *HFONT, *HICON, *HBITMAP, *HGDIOBJ, *HCURSOR, *HRGN;

typedef struct
{
  HWND  hwndFrom;
  UINT_PTR  idFrom;
  UINT  code;
} NMHDR, *LPNMHDR;


typedef struct {
  NMHDR   hdr;
  DWORD_PTR   dwItemSpec;
  DWORD_PTR   dwItemData;
  POINT   pt;
  DWORD   dwHitInfo;
} NMMOUSE, *LPNMMOUSE;
typedef NMMOUSE NMCLICK;
typedef LPNMMOUSE LPNMCLICK;

typedef struct 
{ 
  int mask, fmt,cx; 
  char *pszText; 
  int cchTextMax, iSubItem;
} LVCOLUMN;
typedef struct 
{ 
  int mask, iItem, iSubItem, state, stateMask; 
  char *pszText; 
  int cchTextMax, iImage;
  LPARAM lParam;
} LVITEM;

typedef int (*PFNLVCOMPARE)(LPARAM, LPARAM, LPARAM);

typedef void *HIMAGELIST;

typedef struct
{
  POINT pt;
  UINT flags;
  int iItem;
  int iSubItem;    // this is was NOT in win95.  valid only for LVM_SUBITEMHITTEST
} LVHITTESTINFO, *LPLVHITTESTINFO;


typedef struct
{
  NMHDR   hdr;
  int     iItem;
  int     iSubItem;
  UINT    uNewState;
  UINT    uOldState;
  UINT    uChanged;
  POINT   ptAction;
  LPARAM  lParam;
} NMLISTVIEW, *LPNMLISTVIEW;

typedef struct {
  NMHDR hdr;
  LVITEM item;
} NMLVDISPINFO, *LPNMLVDISPINFO;

typedef struct TCITEM
{
  UINT mask;
  DWORD dwState;
  DWORD dwStateMask;
  char *pszText;
  int cchTextMax;
  int iImage;
  
  LPARAM lParam;
} TCITEM, *LPTCITEM;

typedef struct tagDRAWITEMSTRUCT {
    UINT        CtlType;
    UINT        CtlID;
    UINT        itemID;
    UINT        itemAction;
    UINT        itemState;
    HWND        hwndItem;
    HDC         hDC;
    RECT        rcItem;
    DWORD_PTR   itemData;
} DRAWITEMSTRUCT, *PDRAWITEMSTRUCT, *LPDRAWITEMSTRUCT;

typedef struct tagBITMAP {
  LONG bmWidth;
  LONG bmHeight;
} BITMAP, *PBITMAP, *LPBITMAP;
#define ODT_MENU        1
#define ODT_LISTBOX     2
#define ODT_COMBOBOX    3
#define ODT_BUTTON      4

#define ODS_SELECTED    0x0001




typedef struct 
{  
        DWORD cbSize;
        HWND hWnd;
        UINT uID;
        UINT uFlags;
        UINT uCallbackMessage;
        HICON hIcon;      
        CHAR   szTip[64];
} NOTIFYICONDATA,*PNOTIFYICONDATA, *LPNOTIFYICONDATA;


#define NIM_ADD         0x00000000
#define NIM_MODIFY      0x00000001
#define NIM_DELETE      0x00000002

#define NIF_MESSAGE     0x00000001
#define NIF_ICON        0x00000002
#define NIF_TIP         0x00000004



typedef void *HTREEITEM;

#define TVIF_TEXT               0x0001
#define TVIF_IMAGE              0x0002
#define TVIF_PARAM              0x0004
#define TVIF_STATE              0x0008
#define TVIF_HANDLE             0x0010
#define TVIF_SELECTEDIMAGE      0x0020
#define TVIF_CHILDREN           0x0040

#define TVIS_SELECTED           0x0002
#define TVIS_DROPHILITED        0x0008
#define TVIS_BOLD               0x0010
#define TVIS_EXPANDED           0x0020

#define TVE_COLLAPSE            0x0001
#define TVE_EXPAND              0x0002
#define TVE_TOGGLE              0x0003

#define TVN_FIRST               (0U-400U)       // treeview
#define TVN_SELCHANGED          (TVN_FIRST-2)

#define TVI_ROOT                ((HTREEITEM)0xFFFF0000)
#define TVI_FIRST               ((HTREEITEM)0xFFFF0001)
#define TVI_LAST                ((HTREEITEM)0xFFFF0002)
#define TVI_SORT                ((HTREEITEM)0xFFFF0003)

#define TVHT_NOWHERE            0x0001
#define TVHT_ONITEMICON         0x0002
#define TVHT_ONITEMLABEL        0x0004
#define TVHT_ONITEM             (TVHT_ONITEMICON | TVHT_ONITEMLABEL | TVHT_ONITEMSTATEICON)
#define TVHT_ONITEMINDENT       0x0008
#define TVHT_ONITEMBUTTON       0x0010
#define TVHT_ONITEMRIGHT        0x0020
#define TVHT_ONITEMSTATEICON    0x0040

#define TVHT_ABOVE              0x0100
#define TVHT_BELOW              0x0200
#define TVHT_TORIGHT            0x0400
#define TVHT_TOLEFT             0x0800

typedef struct {
  UINT      mask;
  HTREEITEM hItem;
  UINT      state;
  UINT      stateMask;
  char *pszText;
  int       cchTextMax;
  int       iImage;
  int       iSelectedImage;
  int       cChildren;
  LPARAM    lParam;
} TVITEM, TV_ITEM, *LPTVITEM, *LPTV_ITEM;

typedef struct {
  HTREEITEM hParent;
  HTREEITEM hInsertAfter;
  TVITEM item;
} TVINSERTSTRUCT, *LPTVINSERTSTRUCT, TV_INSERTSTRUCT, *LPTV_INSERTSTRUCT;

typedef struct {
  POINT       pt;
  UINT        flags;
  HTREEITEM   hItem;
} TVHITTESTINFO, *LPTVHITTESTINFO;

typedef struct {
  NMHDR       hdr;
  UINT        action;
  TVITEM    itemOld;
  TVITEM    itemNew;
  POINT       ptDrag;
} NMTREEVIEW, *LPNMTREEVIEW;


typedef struct
{
  unsigned int cbSize, fMask, fType, fState, wID;
  HMENU hSubMenu;
  void *hbmpChecked,*hbmpUnchecked;
  DWORD_PTR dwItemData;
  char *dwTypeData;
  int cch;
} MENUITEMINFO;

#define SetMenuDefaultItem(a,b,c) (0)

typedef struct {
  POINT ptReserved, ptMaxSize, ptMaxPosition, ptMinTrackSize, ptMaxTrackSize;
} MINMAXINFO, *LPMINMAXINFO;


typedef struct
{
  int lfHeight, lfWidth, lfEscapement,lfOrientation, lfWeight;
  char lfItalic, lfUnderline, lfStrikeOut, lfCharSet, lfOutPrecision, lfClipPrecision, 
    lfQuality, lfPitchAndFamily;
  char lfFaceName[32];
} LOGFONT;
typedef struct
{
  LONG tmHeight; 
  LONG tmAscent; 
  LONG tmDescent; 
  LONG tmInternalLeading; 
  LONG tmAveCharWidth;
  // todo: implement rest
} TEXTMETRIC;

typedef struct {
  HDC         hdc;
  BOOL        fErase;
  RECT        rcPaint;
} PAINTSTRUCT;

typedef struct
{
  UINT    cbSize;
  UINT    fMask;
  int     nMin;
  int     nMax;
  UINT    nPage;
  int     nPos;
  int     nTrackPos;
} SCROLLINFO, *LPSCROLLINFO;

typedef struct
{
  DWORD   styleOld;
  DWORD   styleNew;
} STYLESTRUCT, *LPSTYLESTRUCT;

typedef struct _DROPFILES {
   DWORD pFiles;                       // offset of file list
   POINT pt;                           // drop point (client coords)
   BOOL fNC;                           // is it on NonClient area
                                       // and pt is in screen coords
   BOOL fWide;                         // WIDE character switch
} DROPFILES, *LPDROPFILES;


typedef struct
{
  HWND    hwnd;
  HWND    hwndInsertAfter;
  int     x;
  int     y;
  int     cx;
  int     cy;
  UINT    flags;
} WINDOWPOS, *LPWINDOWPOS, *PWINDOWPOS;

typedef struct  
{
  RECT       rgrc[3];
  PWINDOWPOS lppos;
} NCCALCSIZE_PARAMS, *LPNCCALCSIZE_PARAMS;



typedef INT_PTR (*DLGPROC)(HWND, UINT, WPARAM, LPARAM);
typedef LRESULT (*WNDPROC)(HWND, UINT, WPARAM, LPARAM);


#define WM_GESTURE 0x119

#define GF_BEGIN 1
#define GF_INERTIA 2
#define GF_END 4

#define GID_BEGIN 1
#define GID_END   2
#define GID_ZOOM  3
#define GID_PAN   4
#define GID_ROTATE  5
#define GID_TWOFINGERTAP  6
#define GID_ROLLOVER      7

typedef struct tagGESTUREINFO
{
  UINT cbSize;
  DWORD dwFlags;
  DWORD dwID;
  HWND hwndTarget;
  POINTS ptsLocation;
  DWORD dwInstanceID;
  DWORD dwSequenceID;
  ULONGLONG ullArguments;
  UINT cbExtraArgs;
} GESTUREINFO;

// not using this stuff yet
#define GC_PAN 1
#define GC_PAN_WITH_SINGLE_FINGER_VERTICALLY 2
#define GC_PAN_WITH_SINGLE_FINGER_HORIZONTALLY 4

typedef struct tagGESTURECONFIG
{
  DWORD dwID;
  DWORD dwWant;
  DWORD dwBlock;
} GESTURECONFIG;



#ifndef WINAPI
#define WINAPI
#endif

#ifndef CALLBACK
#define CALLBACK
#endif


typedef BOOL (*PROPENUMPROCEX)(HWND hwnd, const char *lpszString, HANDLE hData, LPARAM lParam);

// swell specific type
typedef HWND (*SWELL_ControlCreatorProc)(HWND parent, const char *cname, int idx, const char *classname, int style, int x, int y, int w, int h);                                           

#define DLL_PROCESS_DETACH   0    
#define DLL_PROCESS_ATTACH   1    

// if the user implements this (and links with swell-modstub[-generic], this will get called for DLL_PROCESS_[AT|DE]TACH
#ifdef __cplusplus
extern "C"  {
#endif
__attribute__ ((visibility ("default"))) BOOL WINAPI DllMain(HINSTANCE hInstDLL, DWORD fdwReason, LPVOID lpvReserved);
#ifdef __cplusplus
};
#endif

/*
 ** win32 specific constants
 */
#define MB_OK 0
#define MB_OKCANCEL 1
#define MB_YESNOCANCEL 3
#define MB_YESNO 4
#define MB_RETRYCANCEL 5

#define MB_ICONSTOP 0
#define MB_ICONINFORMATION 0

#define IDOK                1
#define IDCANCEL            2
#define IDABORT             3
#define IDRETRY             4
#define IDIGNORE            5
#define IDYES               6
#define IDNO                7

#define GW_HWNDFIRST        0
#define GW_HWNDLAST         1
#define GW_HWNDNEXT         2
#define GW_HWNDPREV         3
#define GW_OWNER            4
#define GW_CHILD            5

#define GWL_USERDATA        (-21)
#define GWL_ID              (-12)
#define GWL_STYLE           (-16) // only supported for BS_ for now I think
#define GWL_EXSTYLE         (-20)
#define GWL_WNDPROC         (-4)
#define DWL_DLGPROC         (-8)

#define SWELL_NOT_WS_VISIBLE 0x80000000L
#define WS_CHILDWINDOW (WS_CHILD)
#define WS_CHILD      0x40000000L
#define WS_DISABLED   0x08000000L
#define WS_CAPTION    0x00C00000L
#define WS_VSCROLL    0x00200000L
#define WS_HSCROLL    0x00100000L
#define WS_SYSMENU    0x00080000L
#define WS_THICKFRAME 0x00040000L
#define WS_GROUP      0x00020000L
#define WS_TABSTOP    0x00010000L

#define WS_BORDER 0 // ignored for now
#define WS_VISIBLE 0


#define WM_CTLCOLORMSGBOX 0x0132
#define WM_CTLCOLOREDIT 0x0133
#define WM_CTLCOLORLISTBOX 0x0134
#define WM_CTLCOLORBTN 0x0135
#define WM_CTLCOLORDLG 0x0136
#define WM_CTLCOLORSCROLLBAR 0x0137
#define WM_CTLCOLORSTATIC 0x0138

#define CB_ADDSTRING                0x0143
#define CB_DELETESTRING             0x0144
#define CB_GETCOUNT                 0x0146
#define CB_GETCURSEL                0x0147
#define CB_GETLBTEXT                0x0148
#define CB_INSERTSTRING             0x014A
#define CB_RESETCONTENT             0x014B
#define CB_FINDSTRING               0x014C
#define CB_SETCURSEL                0x014E
#define CB_GETITEMDATA              0x0150
#define CB_SETITEMDATA              0x0151
#define CB_FINDSTRINGEXACT          0x0158
#define CB_INITSTORAGE              0x0161

#define LB_ADDSTRING            0x0180
#define LB_INSERTSTRING         0x0181
#define LB_DELETESTRING         0x0182
#define LB_GETTEXT              0x0183
#define LB_RESETCONTENT         0x0184
#define LB_SETSEL               0x0185
#define LB_SETCURSEL            0x0186
#define LB_GETSEL               0x0187
#define LB_GETCURSEL            0x0188
#define LB_GETCOUNT             0x018B
#define LB_GETSELCOUNT          0x0190
#define LB_GETITEMDATA          0x0199
#define LB_SETITEMDATA          0x019A

#define TBM_GETPOS              (WM_USER)
#define TBM_SETTIC              (WM_USER+4)
#define TBM_SETPOS              (WM_USER+5)
#define TBM_SETRANGE            (WM_USER+6)
#define TBM_SETSEL              (WM_USER+10)

#define PBM_SETRANGE            (WM_USER+1)
#define PBM_SETPOS              (WM_USER+2)
#define PBM_DELTAPOS            (WM_USER+3)

#define BM_SETCHECK        0x00F1
#define BM_GETIMAGE        0x00F6
#define BM_SETIMAGE        0x00F7
#define IMAGE_BITMAP 0
#define IMAGE_ICON 1

#define NM_FIRST                (0U-  0U)       // generic to all controls
#define NM_LAST                 (0U- 99U)
#define NM_CLICK                (NM_FIRST-2)    // uses NMCLICK struct
#define NM_DBLCLK               (NM_FIRST-3)
#define NM_RCLICK               (NM_FIRST-5)    // uses NMCLICK struct


#define LVSIL_STATE 1
#define LVSIL_SMALL 2

#define LVIR_BOUNDS             0
#define LVIR_ICON               1
#define LVIR_LABEL              2
#define LVIR_SELECTBOUNDS       3


#define LVHT_NOWHERE            0x0001
#define LVHT_ONITEMICON         0x0002
#define LVHT_ONITEMLABEL        0x0004
#define LVHT_ONITEMSTATEICON    0x0008
#define LVHT_ONITEM             (LVHT_ONITEMICON | LVHT_ONITEMLABEL | LVHT_ONITEMSTATEICON)

#define LVHT_ABOVE              0x0010
#define LVHT_BELOW              0x0020
#define LVHT_TORIGHT            0x0040
#define LVHT_TOLEFT             0x0080

#define LVCF_FMT  1
#define LVCF_WIDTH 2
#define LVCF_TEXT 4

#define LVCFMT_LEFT 0
#define LVCFMT_RIGHT 1
#define LVCFMT_CENTER 2

#define LVIF_TEXT 1
#define LVIF_IMAGE 2
#define LVIF_PARAM 4
#define LVIF_STATE 8

#define LVIS_SELECTED 1
#define LVIS_FOCUSED 2
#define LVNI_SELECTED 1
#define LVNI_FOCUSED 2
#define INDEXTOSTATEIMAGEMASK(x) ((x)<<16)
#define LVIS_STATEIMAGEMASK (255<<16)

#define LVN_FIRST               (0U-100U)       // listview
#define LVN_LAST                (0U-199U)
#define LVN_BEGINDRAG           (LVN_FIRST-9)
#define LVN_COLUMNCLICK         (LVN_FIRST-8)
#define LVN_ITEMCHANGED         (LVN_FIRST-1)
#define LVN_ODFINDITEM          (LVN_FIRST-52)
#define LVN_GETDISPINFO         (LVN_FIRST-50)

// ignored for now
#define LVS_EX_FULLROWSELECT 0



#define TCIF_TEXT               0x0001
#define TCIF_IMAGE              0x0002
#define TCIF_PARAM              0x0008
//#define TCIF_STATE              0x0010



#define TCN_FIRST               (0U-550U)       // tab control
#define TCN_LAST                (0U-580U)
#define TCN_SELCHANGE           (TCN_FIRST - 1)


#define BS_AUTOCHECKBOX    0x00000003L
#define BS_AUTO3STATE      0x00000006L
#define BS_AUTORADIOBUTTON 0x00000009L
#define BS_OWNERDRAW       0x0000000BL



#define BST_CHECKED 1
#define BST_UNCHECKED 0
#define BST_INDETERMINATE 2

// note: these differ in values from their win32 counterparts, because we got them
// wrong to begin with, and we'd like to keep backwards compatability for things compiled
// against an old swell.h (and using the SWELL API via an exported mechanism, i.e. third party
// plug-ins). 
#define SW_HIDE 0
#define SW_SHOWNA 1        // 8 on win32
#define SW_SHOW 2          // 1 on win32
#define SW_SHOWMINIMIZED 3 // 2 on win32

// aliases (todo implement these as needed)
#define SW_SHOWNOACTIVATE SW_SHOWNA 
#define SW_NORMAL SW_SHOW 
#define SW_SHOWNORMAL SW_SHOW
#define SW_SHOWMAXIMIZED SW_SHOW
#define SW_SHOWDEFAULT SW_SHOWNORMAL
#define SW_RESTORE SW_SHOWNA

#define SWP_NOMOVE 1
#define SWP_NOSIZE 2
#define SWP_NOZORDER 4
#define SWP_NOACTIVATE 8
#define SWP_SHOWWINDOW 16
#define SWP_NOCOPYBITS 0
#define HWND_TOP        ((HWND)0)
#define HWND_BOTTOM     ((HWND)1)
#define HWND_TOPMOST    ((HWND)-1)
#define HWND_NOTOPMOST  ((HWND)-2)

// most of these are ignored, actually, but TPM_NONOTIFY and TPM_RETURNCMD are now used
#define TPM_LEFTBUTTON  0x0000L
#define TPM_RIGHTBUTTON 0x0002L
#define TPM_LEFTALIGN   0x0000L
#define TPM_CENTERALIGN 0x0004L
#define TPM_RIGHTALIGN  0x0008L
#define TPM_TOPALIGN        0x0000L
#define TPM_VCENTERALIGN    0x0010L
#define TPM_BOTTOMALIGN     0x0020L
#define TPM_HORIZONTAL      0x0000L     /* Horz alignment matters more */
#define TPM_VERTICAL        0x0040L     /* Vert alignment matters more */
#define TPM_NONOTIFY        0x0080L     /* Don't send any notification msgs */
#define TPM_RETURNCMD       0x0100L

#define MIIM_ID 1
#define MIIM_STATE 2
#define MIIM_TYPE 4
#define MIIM_SUBMENU 8
#define MIIM_DATA 16
#define MFT_STRING 0
#define MF_STRING 0
#define MFT_SEPARATOR 1
#define MFT_BITMAP 2
#define MFT_RADIOCHECK 0 // todo this will need to get implemented

#define MF_SEPARATOR        0x00000800L

#define MF_UNCHECKED 0
#define MF_ENABLED 0
#define MF_GRAYED 1
#define MF_DISABLED 1
#define MF_CHECKED 4

#define MFS_UNCHECKED 0
#define MFS_ENABLED 0
#define MFS_GRAYED 1
#define MFS_CHECKED 4

#define MF_BYCOMMAND 0
#define MF_BYPOSITION 0x100


#define EN_CHANGE           0x0300
#define STN_CLICKED         0
#define STN_DBLCLK          1
#define WM_CREATE                       0x0001
#define WM_DESTROY                      0x0002
#define WM_MOVE                         0x0003
#define WM_SIZE                         0x0005
#define WM_ACTIVATE                     0x0006
#define WM_PAINT                        0x000F
#define WM_CLOSE                        0x0010
#define WM_ERASEBKGND                   0x0014
#define WM_ACTIVATEAPP                  0x001C
#define WM_SETCURSOR                    0x0020
#define WM_MOUSEACTIVATE                0x0021
#define WM_GETMINMAXINFO                0x0024
#define WM_DRAWITEM                     0x002B
#define WM_SETFONT                      0x0030
#define WM_GETFONT                      0x0031
#define WM_NOTIFY                       0x004E

#define WM_CONTEXTMENU                  0x007B
#define WM_STYLECHANGED                 0x007D
#define WM_DISPLAYCHANGE                0x007E
#define WM_NCDESTROY                    0x0082
#define WM_NCCALCSIZE                   0x0083
#define WM_NCHITTEST                    0x0084
#define WM_NCPAINT                      0x0085
#define WM_NCMOUSEMOVE                  0x00A0
#define WM_NCLBUTTONDOWN                0x00A1
#define WM_NCLBUTTONUP                  0x00A2
#define WM_NCLBUTTONDBLCLK              0x00A3
#define WM_NCRBUTTONDOWN                0x00A4
#define WM_NCRBUTTONUP                  0x00A5
#define WM_NCRBUTTONDBLCLK              0x00A6
#define WM_NCMBUTTONDOWN                0x00A7
#define WM_NCMBUTTONUP                  0x00A8
#define WM_NCMBUTTONDBLCLK              0x00A9
#define WM_KEYFIRST                     0x0100
#define WM_KEYDOWN                      0x0100
#define WM_KEYUP                        0x0101
#define WM_CHAR                         0x0102
#define WM_DEADCHAR                     0x0103
#define WM_SYSKEYDOWN                   0x0104
#define WM_SYSKEYUP                     0x0105
#define WM_SYSCHAR                      0x0106
#define WM_SYSDEADCHAR                  0x0107
#define WM_KEYLAST                      0x0108
#define WM_INITDIALOG                   0x0110
#define WM_COMMAND                      0x0111
#define WM_SYSCOMMAND                   0x0112
#define SC_CLOSE        0xF060
#define WM_TIMER                        0x0113
#define WM_INITMENUPOPUP                0x0117
#define WM_HSCROLL                      0x0114
#define WM_VSCROLL                      0x0115
#define WM_MOUSEFIRST                   0x0200
#define WM_MOUSEMOVE                    0x0200
#define WM_LBUTTONDOWN                  0x0201
#define WM_LBUTTONUP                    0x0202
#define WM_LBUTTONDBLCLK                0x0203
#define WM_RBUTTONDOWN                  0x0204
#define WM_RBUTTONUP                    0x0205
#define WM_RBUTTONDBLCLK                0x0206
#define WM_MBUTTONDOWN                  0x0207
#define WM_MBUTTONUP                    0x0208
#define WM_MBUTTONDBLCLK                0x0209
#define WM_MOUSEWHEEL                   0x020A
#define WM_MOUSEHWHEEL                  0x020E
#define WM_MOUSELAST                    0x020A
#define WM_CAPTURECHANGED               0x0215
#define WM_DROPFILES                    0x0233
#define WM_USER                         0x0400      

#define     WA_INACTIVE     0
#define     WA_ACTIVE       1
#define     WA_CLICKACTIVE  2

#define BN_CLICKED 0

#define LBN_SELCHANGE       1
#define LBN_DBLCLK          2
#define LB_ERR (-1)

#define CBN_SELCHANGE       1
#define CBN_EDITCHANGE      5
#define CBN_DROPDOWN        7
#define CB_ERR (-1)

#define EM_GETSEL               0xF0B0
#define EM_SETSEL               0xF0B1
#define EM_SCROLL               0xF0B5

#define SB_HORZ             0
#define SB_VERT             1
#define SB_CTL              2
#define SB_BOTH             3

#define SB_LINEUP           0
#define SB_LINELEFT         0
#define SB_LINEDOWN         1
#define SB_LINERIGHT        1
#define SB_PAGEUP           2
#define SB_PAGELEFT         2
#define SB_PAGEDOWN         3
#define SB_PAGERIGHT        3
#define SB_THUMBPOSITION    4
#define SB_THUMBTRACK       5
#define SB_TOP              6
#define SB_LEFT             6
#define SB_BOTTOM           7
#define SB_RIGHT            7
#define SB_ENDSCROLL        8

#define DFCS_SCROLLUP           0x0000
#define DFCS_SCROLLDOWN         0x0001
#define DFCS_SCROLLLEFT         0x0002
#define DFCS_SCROLLRIGHT        0x0003
#define DFCS_SCROLLCOMBOBOX     0x0005
#define DFCS_SCROLLSIZEGRIP     0x0008
#define DFCS_SCROLLSIZEGRIPRIGHT 0x0010

#define DFCS_INACTIVE           0x0100
#define DFCS_PUSHED             0x0200
#define DFCS_CHECKED            0x0400
#define DFCS_FLAT               0x4000

#define DFCS_BUTTONPUSH         0x0010

#define DFC_SCROLL              3
#define DFC_BUTTON              4

#define ESB_ENABLE_BOTH     0x0000
#define ESB_DISABLE_BOTH    0x0003

#define ESB_DISABLE_LEFT    0x0001
#define ESB_DISABLE_RIGHT   0x0002

#define ESB_DISABLE_UP      0x0001
#define ESB_DISABLE_DOWN    0x0002

#define BDR_RAISEDOUTER 0x0001
#define BDR_SUNKENOUTER 0x0002
#define BDR_RAISEDINNER 0x0004
#define BDR_SUNKENINNER 0x0008

#define BDR_OUTER       0x0003
#define BDR_INNER       0x000c

#define EDGE_RAISED     (BDR_RAISEDOUTER | BDR_RAISEDINNER)
#define EDGE_SUNKEN     (BDR_SUNKENOUTER | BDR_SUNKENINNER)
#define EDGE_ETCHED     (BDR_SUNKENOUTER | BDR_RAISEDINNER)
#define EDGE_BUMP       (BDR_RAISEDOUTER | BDR_SUNKENINNER)

#define BF_ADJUST       0x2000
#define BF_FLAT         0x4000
#define BF_LEFT         0x0001
#define BF_TOP          0x0002
#define BF_RIGHT        0x0004
#define BF_BOTTOM       0x0008
#define BF_RECT         (BF_LEFT | BF_TOP | BF_RIGHT | BF_BOTTOM)

#define PATCOPY             (DWORD)0x00F00021

#define HTHSCROLL           6
#define HTVSCROLL           7

#define WS_EX_LEFTSCROLLBAR     0x00004000L
#define WS_EX_ACCEPTFILES       0x00000010L

#define SIF_RANGE           0x0001
#define SIF_PAGE            0x0002
#define SIF_POS             0x0004
#define SIF_DISABLENOSCROLL 0x0008
#define SIF_TRACKPOS        0x0010
#define SIF_ALL             (SIF_RANGE | SIF_PAGE | SIF_POS | SIF_TRACKPOS)

#define SIZE_RESTORED       0
#define SIZE_MINIMIZED      1
#define SIZE_MAXIMIZED      2
#define SIZE_MAXSHOW        3
#define SIZE_MAXHIDE        4


#ifndef MAKEINTRESOURCE
#define MAKEINTRESOURCE(x) ((const char *)(UINT_PTR)(x))         
#endif                

#define FVIRTKEY  1
#define FSHIFT    0x04
#define FCONTROL  0x08
#define FALT      0x10


#define VK_LBUTTON        0x01
#define VK_RBUTTON        0x02
#define VK_MBUTTON        0x04

#define VK_BACK           0x08
#define VK_TAB            0x09

#define VK_CLEAR          0x0C
#define VK_RETURN         0x0D

#define VK_SHIFT          0x10
#define VK_CONTROL        0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL        0x14

#define VK_ESCAPE         0x1B

#define VK_SPACE          0x20
#define VK_PRIOR          0x21
#define VK_NEXT           0x22
#define VK_END            0x23
#define VK_HOME           0x24
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28
#define VK_SELECT         0x29
#define VK_PRINT          0x2A
#define VK_SNAPSHOT       0x2C
#define VK_INSERT         0x2D
#define VK_DELETE         0x2E
#define VK_HELP           0x2F

#define VK_NUMPAD0        0x60
#define VK_NUMPAD1        0x61
#define VK_NUMPAD2        0x62
#define VK_NUMPAD3        0x63
#define VK_NUMPAD4        0x64
#define VK_NUMPAD5        0x65
#define VK_NUMPAD6        0x66
#define VK_NUMPAD7        0x67
#define VK_NUMPAD8        0x68
#define VK_NUMPAD9        0x69
#define VK_MULTIPLY       0x6A
#define VK_ADD            0x6B
#define VK_SEPARATOR      0x6C
#define VK_SUBTRACT       0x6D
#define VK_DECIMAL        0x6E
#define VK_DIVIDE         0x6F
#define VK_F1             0x70
#define VK_F2             0x71
#define VK_F3             0x72
#define VK_F4             0x73
#define VK_F5             0x74
#define VK_F6             0x75
#define VK_F7             0x76
#define VK_F8             0x77
#define VK_F9             0x78
#define VK_F10            0x79
#define VK_F11            0x7A
#define VK_F12            0x7B
#define VK_NUMLOCK        0x90
#define VK_SCROLL         0x91

#define MK_LBUTTON        0x01
#define MK_RBUTTON        0x02
#define MK_MBUTTON        0x10


#define IDC_SIZENESW MAKEINTRESOURCE(-1007)
#define IDC_SIZENWSE MAKEINTRESOURCE(-1006)
#define IDC_IBEAM MAKEINTRESOURCE(-1005)
#define IDC_UPARROW MAKEINTRESOURCE(-1004)
#define IDC_NO MAKEINTRESOURCE(-1003)
#define IDC_SIZEALL MAKEINTRESOURCE(-1002)
#define IDC_SIZENS MAKEINTRESOURCE(-1001)
#define IDC_SIZEWE MAKEINTRESOURCE(-1000)
#define IDC_ARROW MAKEINTRESOURCE(-999)
#define IDC_HAND MAKEINTRESOURCE(32649)




#define COLOR_3DSHADOW 0
#define COLOR_3DHILIGHT 1
#define COLOR_3DFACE 2
#define COLOR_BTNTEXT 3
#define COLOR_WINDOW 4
#define COLOR_SCROLLBAR 5
#define COLOR_3DDKSHADOW 6
#define COLOR_BTNFACE 7
#define COLOR_INFOBK 8
#define COLOR_INFOTEXT 9

#define SRCCOPY 0
#define PS_SOLID 0
#define DT_CALCRECT 1
#define DT_VCENTER 2
#define DT_CENTER 4
#define DT_END_ELLIPSIS 8
#define DT_BOTTOM 16
#define DT_RIGHT 32
#define DT_SINGLELINE 64
#define DT_NOPREFIX 128
#define DT_NOCLIP 256

#define DT_TOP 0
#define DT_LEFT 0

#define FW_DONTCARE         0
#define FW_THIN             100
#define FW_EXTRALIGHT       200
#define FW_LIGHT            300
#define FW_NORMAL           400
#define FW_MEDIUM           500
#define FW_SEMIBOLD         600
#define FW_BOLD             700
#define FW_EXTRABOLD        800
#define FW_HEAVY            900

#define FW_ULTRALIGHT       FW_EXTRALIGHT
#define FW_REGULAR          FW_NORMAL
#define FW_DEMIBOLD         FW_SEMIBOLD
#define FW_ULTRABOLD        FW_EXTRABOLD
#define FW_BLACK            FW_HEAVY

#define OUT_DEFAULT_PRECIS 0
#define CLIP_DEFAULT_PRECIS 0
#define DEFAULT_QUALITY 0
#define DRAFT_QUALITY 1
#define PROOF_QUALITY 2
#define NONANTIALIASED_QUALITY 3
#define ANTIALIASED_QUALITY 4
#define DEFAULT_PITCH 0
#define DEFAULT_CHARSET 0
#define ANSI_CHARSET 0
#define TRANSPARENT 0
#define OPAQUE 1

#define NULL_PEN 1
#define NULL_BRUSH 2

#define GMEM_ZEROINIT 1
#define GMEM_FIXED 0
#define GMEM_MOVEABLE 0
#define GMEM_DDESHARE 0
#define GMEM_DISCARDABLE 0
#define GMEM_SHARE 0
#define GMEM_LOWER 0
#define GHND (GMEM_MOVEABLE|GM_ZEROINIT)
#define GPTR (GMEM_FIXED|GMEM_ZEROINIT)


#define _MCW_RC         0x00000300              /* Rounding Control */
#define _RC_NEAR        0x00000000              /*   near */
#define _RC_DOWN        0x00000100              /*   down */
#define _RC_UP          0x00000200              /*   up */
#define _RC_CHOP        0x00000300              /*   chop */


extern struct SWELL_CursorResourceIndex *SWELL_curmodule_cursorresource_head;
extern struct SWELL_DialogResourceIndex *SWELL_curmodule_dialogresource_head;
extern struct SWELL_MenuResourceIndex *SWELL_curmodule_menuresource_head;

#define HTNOWHERE           0
#define HTCLIENT            1
#define HTMENU              5
#define HTHSCROLL           6
#define HTVSCROLL           7

#define SM_CXSCREEN             0
#define SM_CYSCREEN             1
#define SM_CXVSCROLL            2
#define SM_CYHSCROLL            3
#define SM_CYVSCROLL            20
#define SM_CXHSCROLL            21


#if 0 // these are disabled until implemented

#define SM_CYCAPTION            4
#define SM_CXBORDER             5
#define SM_CYBORDER             6
#define SM_CXDLGFRAME           7
#define SM_CYDLGFRAME           8
#define SM_CYVTHUMB             9
#define SM_CXHTHUMB             10
#define SM_CXICON               11
#define SM_CYICON               12
#define SM_CXCURSOR             13
#define SM_CYCURSOR             14
#define SM_CYMENU               15
#define SM_CXFULLSCREEN         16
#define SM_CYFULLSCREEN         17
#define SM_CYKANJIWINDOW        18
#define SM_MOUSEPRESENT         19
#define SM_DEBUG                22
#define SM_SWAPBUTTON           23
#define SM_CXMIN                28
#define SM_CYMIN                29
#define SM_CXSIZE               30
#define SM_CYSIZE               31
#define SM_CXFRAME              32
#define SM_CYFRAME              33
#define SM_CXMINTRACK           34
#define SM_CYMINTRACK           35
#define SM_CXDOUBLECLK          36
#define SM_CYDOUBLECLK          37
#define SM_CXICONSPACING        38
#define SM_CYICONSPACING        39

#endif // unimplemented system metrics


#define THREAD_BASE_PRIORITY_LOWRT  15
#define THREAD_BASE_PRIORITY_MAX    2
#define THREAD_BASE_PRIORITY_MIN    -2
#define THREAD_BASE_PRIORITY_IDLE   -15
#define THREAD_PRIORITY_LOWEST          THREAD_BASE_PRIORITY_MIN
#define THREAD_PRIORITY_BELOW_NORMAL    (THREAD_PRIORITY_LOWEST+1)
#define THREAD_PRIORITY_NORMAL          0
#define THREAD_PRIORITY_HIGHEST         THREAD_BASE_PRIORITY_MAX
#define THREAD_PRIORITY_ABOVE_NORMAL    (THREAD_PRIORITY_HIGHEST-1)
#define THREAD_PRIORITY_TIME_CRITICAL   THREAD_BASE_PRIORITY_LOWRT
#define THREAD_PRIORITY_IDLE            THREAD_BASE_PRIORITY_IDLE



#define WAIT_OBJECT_0       (0 )
#define WAIT_TIMEOUT                        (0x00000102L)
#define WAIT_FAILED (DWORD)0xFFFFFFFF
#define INFINITE            0xFFFFFFFF


#endif //_WDL_SWELL_H_TYPES_DEFINED_



#ifndef _WDL_SWELL_H_API_DEFINED_
#define _WDL_SWELL_H_API_DEFINED_

////////////////////////////////////////////
/////////// FUNCTIONS
////////////////////////////////////////////

#ifndef SWELL_API_DEFINE


#ifdef SWELL_PROVIDED_BY_APP
#define SWELL_API_DEFINE(ret,func,parms) extern ret (*func)parms;
#else
#define SWELL_API_DEFINE(ret,func,parms) ret func parms ;
#endif
#endif

/* 
** lstrcpyn: this is provided because strncpy is braindead (filling with zeroes, and not 
** NULL terminating if the destination buffer is too short? ASKING for trouble..)
** lstrpcyn always null terminates the string and doesnt fill anything extra.
*/
SWELL_API_DEFINE(char *, lstrcpyn, (char *dest, const char *src, int l))


/*
** MulDiv(): (parm1*parm2)/parm3
** Implemented using long longs.
*/
SWELL_API_DEFINE(int, MulDiv, (int, int, int))


/*
** Sleep() sleeps for specified milliseconds. This maps to usleep, with a ms value of 0 
** usleeping for 100 microseconds. 
*/
SWELL_API_DEFINE(void, Sleep,(int ms))

/*
** GetTickCount() and timeGetTime() give you ms level timings via gettimeofday(). 
** 
** NOTE: This doesn't map to time since system start (like in win32), so a wrap around 
** is slightly more likely (i.e. even if you booted your system an hour ago it could happen).
*/
SWELL_API_DEFINE(DWORD, GetTickCount,())
#ifndef timeGetTime
#define timeGetTime() GetTickCount()
#endif

/*
** GetFileTime() gets the file time of a file (FILE *), and converts it to the Windows time.
**
** NOTE: while it returns a 64 bit time value, it is only accurate to the second since thats 
** what fstat() returns. Takes an int filedes rather than a HANDLE.
*/
SWELL_API_DEFINE(BOOL, GetFileTime,(int filedes, FILETIME *lpCreationTime, FILETIME *lpLastAccessTime, FILETIME *lpLastWriteTime))

/*
** *PrivateProfileString/Int():
** These are mostly thread-safe, mostly inter-process safe, and mostly module safe 
** (i.e. writes from other modules) should be synchronized).
**
** NOTES:
**   the filename used MUST be the full filename, unlike on Windows where files without paths go to
**   C:/Windows, here they will be opened in the current directory.
**
**   It's probably not a good idea to push your luck with simultaneous writes from multiple
**   modules in different threads/processes, but in theory it should work.
*/
SWELL_API_DEFINE(BOOL, WritePrivateProfileString, (const char *appname, const char *keyname, const char *val, const char *fn))
SWELL_API_DEFINE(DWORD, GetPrivateProfileString, (const char *appname, const char *keyname, const char *def, char *ret, int retsize, const char *fn))
SWELL_API_DEFINE(int, GetPrivateProfileInt,(const char *appname, const char *keyname, int def, const char *fn))
SWELL_API_DEFINE(BOOL, GetPrivateProfileStruct,(const char *appname, const char *keyname, void *buf, int bufsz, const char *fn))
SWELL_API_DEFINE(BOOL, WritePrivateProfileStruct,(const char *appname, const char *keyname, const void *buf, int bufsz, const char *fn))


/*
** GetModuleFileName()
** Can pass NULL (exe filename) or a hInstance from DllMain or LoadLibrary
*/
SWELL_API_DEFINE(DWORD, GetModuleFileName,(HINSTANCE hInst, char *fn, DWORD nSize))

#ifdef SWELL_TARGET_OSX
/*
** SWELL_CStringToCFString(): Creates a CFString/NSString * from a C string. This is mostly 
** used internally but you may wish to use it as well (though none of the SWELL APIs take 
** CFString/NSString.
*/
SWELL_API_DEFINE(void *,SWELL_CStringToCFString,(const char *str))
SWELL_API_DEFINE(void, SWELL_CFStringToCString, (const void *str, char *buf, int buflen))
#endif


/*
** PtInRect() should hopefully function just like it's win32 equivelent.
** there is #define funkiness because some Mac system headers define PtInRect as well.
*/
#ifdef PtInRect
#undef PtInRect
#endif
#define PtInRect(r,p) SWELL_PtInRect(r,p)
SWELL_API_DEFINE(BOOL, SWELL_PtInRect,(RECT *r, POINT p))

/*
** ShellExecute(): 
** NOTE: currently action is ignored, and it only works on content1 being a URL beginning with http://.
** TODO: finish implementation
*/
SWELL_API_DEFINE(BOOL, ShellExecute,(HWND hwndDlg, const char *action,  const char *content1, const char *content2, const char *content3, int blah))

/*
** MessageBox().
*/
SWELL_API_DEFINE(int, MessageBox,(HWND hwndParent, const char *text, const char *caption, int type))


/*
** GetOpenFileName() / GetSaveFileName() 
** These are a different API because we didnt feel like reeimplimenting the full API.
** Extlist is something similar you'd pass getopenfilename, 
** initialdir and initialfile are optional (and NULL means not set).
*/

// free() the result of this, if non-NULL.
// if allowmul is set, the multiple files are specified the same way GetOpenFileName() returns.
SWELL_API_DEFINE(char *,BrowseForFiles,(const char *text, const char *initialdir, 
					const char *initialfile, bool allowmul, const char *extlist)) 

// returns TRUE if file was chosen.         
SWELL_API_DEFINE(bool, BrowseForSaveFile,(const char *text, const char *initialdir, const char *initialfile, const char *extlist,
			char *fn, int fnsize))

// returns TRUE if path was chosen.
SWELL_API_DEFINE(bool, BrowseForDirectory,(const char *text, const char *initialdir, char *fn, int fnsize))

// can use this before calling BrowseForFiles or BrowseForSaveFile to use a template dialog
SWELL_API_DEFINE(void,BrowseFile_SetTemplate,(const char *dlgid, DLGPROC dlgProc, struct SWELL_DialogResourceIndex *reshead))


// Note that window functions are generally NOT threadsafe.
// all of these treat HWND as NSView and/or NSWindow (usually smartish about it)


/* 
** GetDlgItem(hwnd,0) returns hwnd if hwnd is a NSView, or the contentview if hwnd is a NSWindow.
** Note that this GetDlgItem will actually search a view hierarchy for the tagged view, 
** unlike Win32 where it will only look at immediate children.
*/
SWELL_API_DEFINE(HWND, GetDlgItem,(HWND, int))

/*
** ShowWindow() works for hwnds that represent NSView and/or NSWindow.
** SW_SHOW, SW_SHOWNA, and SW_HIDE are defined, and some of the other common uses
** alias to these.
*/
SWELL_API_DEFINE(void, ShowWindow,(HWND, int))


/*
** DestroyWindow() works for both a NSWindow or NSView.
** Note that if the window is a fake window with a procedure 
** (created via CreateDialog or DialogBox below) then WM_DESTROY
** will be called immediately, though the window/view may be freed 
** sometime later via the autorelease pool.
*/
SWELL_API_DEFINE(void, DestroyWindow,(HWND hwnd)) 

SWELL_API_DEFINE(BOOL, SWELL_GetGestureInfo, (LPARAM lParam, GESTUREINFO* gi))

SWELL_API_DEFINE(void, SWELL_HideApp,())

/*
** These should all work like their Win32 versions, though if idx=0 it gets/sets the
** value for the window. Note that SetDlgItemText() for an edit control does NOT send
** a WM_COMMAND notification like on win32, so you will have to do this yourself.
*/
SWELL_API_DEFINE(BOOL, SetDlgItemText,(HWND, int idx, const char *text))
SWELL_API_DEFINE(BOOL, SetDlgItemInt,(HWND, int idx, int val, int issigned))
SWELL_API_DEFINE(int, GetDlgItemInt,(HWND, int idx, BOOL *translated, int issigned))
SWELL_API_DEFINE(BOOL, GetDlgItemText,(HWND, int idx, char *text, int textlen))

#ifndef GetWindowText
#define GetWindowText(hwnd,text,textlen) GetDlgItemText(hwnd,0,text,textlen)
#define SetWindowText(hwnd,text) SetDlgItemText(hwnd,0,text)
#endif


SWELL_API_DEFINE(void, CheckDlgButton,(HWND hwnd, int idx, int check))
SWELL_API_DEFINE(int, IsDlgButtonChecked,(HWND hwnd, int idx))
SWELL_API_DEFINE(void, EnableWindow,(HWND hwnd, int enable))
SWELL_API_DEFINE(void, SetFocus,(HWND hwnd)) // these take NSWindow/NSView, and return NSView *
SWELL_API_DEFINE(HWND, GetFocus,())
SWELL_API_DEFINE(void, SetForegroundWindow,(HWND hwnd)) // these take NSWindow/NSView, and return NSView *
SWELL_API_DEFINE(HWND, GetForegroundWindow,())
#ifndef GetActiveWindow
#define GetActiveWindow() GetForegroundWindow()
#endif
#ifndef SetActiveWindow
#define SetActiveWindow(x) SetForegroundWindow(x)
#endif

/*
** GetCapture/SetCapture/ReleaseCapture are completely faked, with just an internal state.
** Mouse click+drag automatically captures the focus sending mouseDrag events in OSX, so
** these are as a porting aid.
**
** Updated: they actually send WM_CAPTURECHANGED messages now, if the window supports
** onSwellMessage:p1:p2: and swellCapChangeNotify (and swellCapChangeNotify returns YES).
**
** Note that any HWND that returns YES to swellCapChangeNotify should do the following on 
** destroy or dealloc: if (GetCapture()==(HWND)self) ReleaseCapture(); Failure to do so
** can cause a dealloc'd window to get messages sent to it.
*/
SWELL_API_DEFINE(HWND, SetCapture,(HWND hwnd))
SWELL_API_DEFINE(HWND, GetCapture,())
SWELL_API_DEFINE(void, ReleaseCapture,())

/*
** IsChild()
** Notes: hwndChild must be a NSView (if not then false is returned)
** hwndParent can be a NSWindow or NSView. 
** NSWindow level ownership/children are not detected.
*/
SWELL_API_DEFINE(int, IsChild,(HWND hwndParent, HWND hwndChild))


/*
** GetParent()
** Notes: if hwnd is a NSView, then gets the parent view (or NSWindow 
** if the parent view is the window's contentview). If hwnd is a NSWindow,
** then GetParent returns the owner window, if any. Note that the owner 
** window system is not part of OSX, but rather part of SWELL.
*/
SWELL_API_DEFINE(HWND, GetParent,(HWND hwnd))

/*
** SetParent()
** Notes: hwnd must be a NSView, newPar can be either NSView or NSWindow.
*/
SWELL_API_DEFINE(HWND, SetParent,(HWND hwnd, HWND newPar))

/*
** GetWindow()
** Most of the standard GW_CHILD etc work. Does not do anything to prevent you from 
** getting into infinite loops if you go changing the order on the fly etc.
*/
SWELL_API_DEFINE(HWND, GetWindow,(HWND hwnd, int what))

SWELL_API_DEFINE(HWND,FindWindowEx,(HWND par, HWND lastw, const char *classname, const char *title))


/*
** Notes: common win32 code like this:
**   RECT r;
**   GetWindowRect(hwnd,&r); 
**   ScreenToClient(otherhwnd,(LPPOINT)&r);
**   ScreenToClient(otherhwnd,((LPPOINT)&r)+1);
** does work, however be aware that in certain instances r.bottom may be less 
** than r.top, due to flipped coordinates. SetWindowPos and other functions 
** handle negative heights gracefully, and you should too.
**
** Note: GetWindowContentViewRect gets the rectangle of the content view (pre-NCCALCSIZE etc)
*/
SWELL_API_DEFINE(void, ClientToScreen,(HWND hwnd, POINT *p))
SWELL_API_DEFINE(void, ScreenToClient,(HWND hwnd, POINT *p))
SWELL_API_DEFINE(bool, GetWindowRect,(HWND hwnd, RECT *r))
SWELL_API_DEFINE(void, GetWindowContentViewRect, (HWND hwnd, RECT *r)) 
SWELL_API_DEFINE(void, GetClientRect,(HWND hwnd, RECT *r))
SWELL_API_DEFINE(HWND, WindowFromPoint,(POINT p))
SWELL_API_DEFINE(BOOL, WinOffsetRect, (LPRECT lprc, int dx, int dy))
SWELL_API_DEFINE(BOOL, WinSetRect, (LPRECT lprc, int xLeft, int yTop, int xRight, int yBottom))
SWELL_API_DEFINE(void,WinUnionRect,(RECT *out, RECT *in1, RECT *in2))
SWELL_API_DEFINE(int,WinIntersectRect,(RECT *out, RECT *in1, RECT *in2))


/*
** SetWindowPos():
** Notes: Z ordering stuff is ignored, as are most flags. 
** SWP_NOMOVE and SWP_NOSIZE are the only flags used.
*/
SWELL_API_DEFINE(void, SetWindowPos,(HWND hwnd, HWND unused, int x, int y, int cx, int cy, int flags))

SWELL_API_DEFINE(int, SWELL_SetWindowLevel, (HWND hwnd, int newlevel))

/*
** InvalidateRect()
** Notes: eraseBk is ignored, probably not threadsafe! hwnd can be NSWindow or NSView
*/
SWELL_API_DEFINE(void,InvalidateRect,(HWND hwnd, RECT *r, int eraseBk))

/*
** UpdateWindow()
** Notes: not currently implemented but provided here in case someday it is necessary
*/
SWELL_API_DEFINE(void,UpdateWindow,(HWND hwnd))


/*
** GetWindowLong()/SetWindowLong()
**
** GWL_ID is supported for all objects that support the 'tag'/'setTag' methods,
** which would be controls and SWELL created windows/dialogs/controls.
**
** GWL_USERDATA is supported by SWELL created windows/dialogs/controls, using 
** (int)getSwellUserData and setSwellUserData:(int).
** 
** GWL_WNDPROC is supported by SWELL created windows/dialogs/controls, using 
** (int)getSwellWindowProc and setSwellWindowProc:(int).
**
** DWL_DLGPROC is supported by SWELL created dialogs now (it might work in windows/controls but isnt recommended)
**
** GWL_STYLE is only supported for NSButton. Currently the only flags supported are
** BS_AUTO3STATE (BS_AUTOCHECKBOX is returned but also ignored).
**
** indices of >= 0 and < 128 (32 integers) are supported for SWELL created 
** windows/dialogs/controls, via (int)getSwellExtraData:(int)idx and 
** setSwellExtraData:(int)idx value:(int)val . 
*/
SWELL_API_DEFINE(LONG_PTR, GetWindowLong,(HWND hwnd, int idx))
SWELL_API_DEFINE(LONG_PTR, SetWindowLong,(HWND hwnd, int idx, LONG_PTR val))


SWELL_API_DEFINE(BOOL, ScrollWindow, (HWND hwnd, int xamt, int yamt, const RECT *lpRect, const RECT *lpClipRect))

/* 
** GetProp() SetProp() RemoveProp() EnumPropsEx()
** These should work like in win32. Free your props otherwise they will leak.
** Restriction on what you can do in the PROPENUMPROCEX is similar to win32 
** (you can remove only the called prop, and can't add props within it).
** if the prop name is < (void *)65536 then it is treated as a short identifier.
*/
SWELL_API_DEFINE(int, EnumPropsEx,(HWND, PROPENUMPROCEX, LPARAM))
SWELL_API_DEFINE(HANDLE, GetProp, (HWND, const char *))
SWELL_API_DEFINE(BOOL, SetProp, (HWND, const char *, HANDLE))
SWELL_API_DEFINE(HANDLE, RemoveProp, (HWND, const char *))
                

/*
** IsWindowVisible()
** if hwnd is a NSView, returns !isHiddenOrHasHiddenAncestor
** if hwnd is a NSWindow returns isVisible
** otherwise returns TRUE if non-null hwnd
*/
SWELL_API_DEFINE(bool, IsWindowVisible,(HWND hwnd))
#ifndef IsWindow
#define IsWindow(x) (!!(x)) // todo use isKindOf
#endif


/*
** SetTimer/KillTimer():
** Notes:
** The timer API may be threadsafe though it is highly untested.
** Note also that the mechanism for sending timers is SWELL_Timer:(id).
** The fourth parameter to SetTimer() is not supported and will be ignored, so you must
** receive your timers via a WM_TIMER (or SWELL_Timer:(id))
**
** You can kill all timers for a window using KillTimer(hwnd,-1);
** You MUST kill all timers for a window before destroying it. Note that SWELL created 
** windows/dialogs/controls automatically do this, but if you use SetTimer() on a NSView *
** or NSWindow * directly, then you should kill all timers in -dealloc.
*/
SWELL_API_DEFINE(UINT_PTR, SetTimer,(HWND hwnd, UINT_PTR timerid, UINT rate, TIMERPROC tProc))
SWELL_API_DEFINE(BOOL, KillTimer,(HWND hwnd, UINT_PTR timerid))

#ifdef SWELL_TARGET_OSX
/*
** These provide the interfaces for directly updating a combo box control. This is no longer
** required as SendMessage can now be used with CB_* etc.
** Combo boxes may be implemented using a NSComboBox or NSPopUpButton depending on the style.
**
** Notes: CB_SetItemData/CB_GetItemData only work for the non-user-editable version (using NSPopUpbutotn).
*/
SWELL_API_DEFINE(int, SWELL_CB_AddString,(HWND hwnd, int idx, const char *str))
SWELL_API_DEFINE(void, SWELL_CB_SetCurSel,(HWND hwnd, int idx, int sel))
SWELL_API_DEFINE(int, SWELL_CB_GetCurSel,(HWND hwnd, int idx))
SWELL_API_DEFINE(int, SWELL_CB_GetNumItems,(HWND hwnd, int idx))
SWELL_API_DEFINE(void, SWELL_CB_SetItemData,(HWND hwnd, int idx, int item, LONG_PTR data)) // these two only work for the combo list version for now
SWELL_API_DEFINE(LONG_PTR, SWELL_CB_GetItemData,(HWND hwnd, int idx, int item))
SWELL_API_DEFINE(void, SWELL_CB_Empty,(HWND hwnd, int idx))
SWELL_API_DEFINE(int, SWELL_CB_InsertString,(HWND hwnd, int idx, int pos, const char *str))
SWELL_API_DEFINE(int, SWELL_CB_GetItemText,(HWND hwnd, int idx, int item, char *buf, int bufsz))
SWELL_API_DEFINE(void, SWELL_CB_DeleteString,(HWND hwnd, int idx, int wh))
SWELL_API_DEFINE(int, SWELL_CB_FindString,(HWND hwnd, int idx, int startAfter, const char *str, bool exact))


/*
** Trackbar API
** These provide the interfaces for directly updating a trackbar (implemented using NSSlider).
** Note that you can now use SendMessage with TBM_* instead.
*/
SWELL_API_DEFINE(void, SWELL_TB_SetPos,(HWND hwnd, int idx, int pos))
SWELL_API_DEFINE(void, SWELL_TB_SetRange,(HWND hwnd, int idx, int low, int hi))
SWELL_API_DEFINE(int, SWELL_TB_GetPos,(HWND hwnd, int idx))
SWELL_API_DEFINE(void, SWELL_TB_SetTic,(HWND hwnd, int idx, int pos))


#endif

/*
** ListView API. In owner data mode only LVN_GETDISPINFO is used (not ODFINDITEM etc).
** LVN_BEGINDRAG also should work as on windows. Imagelists state icons work as well.
*/
SWELL_API_DEFINE(void, ListView_SetExtendedListViewStyleEx,(HWND h, int flag, int mask))
SWELL_API_DEFINE(void, ListView_InsertColumn,(HWND h, int pos, const LVCOLUMN *lvc))
SWELL_API_DEFINE(bool, ListView_DeleteColumn,(HWND h, int pos))
SWELL_API_DEFINE(void, ListView_SetColumn,(HWND h, int pos, const LVCOLUMN *lvc))
SWELL_API_DEFINE(int, ListView_GetColumnWidth,(HWND h, int pos))
SWELL_API_DEFINE(int, ListView_InsertItem,(HWND h, const LVITEM *item))
SWELL_API_DEFINE(void, ListView_SetItemText,(HWND h, int ipos, int cpos, const char *txt))
SWELL_API_DEFINE(bool, ListView_SetItem,(HWND h, LVITEM *item))
SWELL_API_DEFINE(int, ListView_GetNextItem,(HWND h, int istart, int flags))
SWELL_API_DEFINE(bool, ListView_GetItem,(HWND h, LVITEM *item))
SWELL_API_DEFINE(int, ListView_GetItemState,(HWND h, int ipos, int mask))
SWELL_API_DEFINE(void, ListView_DeleteItem,(HWND h, int ipos))
SWELL_API_DEFINE(void, ListView_DeleteAllItems,(HWND h))
SWELL_API_DEFINE(int, ListView_GetSelectedCount,(HWND h))
SWELL_API_DEFINE(int, ListView_GetItemCount,(HWND h))
SWELL_API_DEFINE(int, ListView_GetSelectionMark,(HWND h))
SWELL_API_DEFINE(void, ListView_SetColumnWidth,(HWND h, int colpos, int wid))
SWELL_API_DEFINE(bool, ListView_SetItemState,(HWND h, int item, int state, int statemask))
SWELL_API_DEFINE(void, ListView_RedrawItems,(HWND h, int startitem, int enditem))
SWELL_API_DEFINE(void, ListView_SetItemCount,(HWND h, int cnt))
SWELL_API_DEFINE(void, ListView_EnsureVisible,(HWND h, int i, BOOL pok))
SWELL_API_DEFINE(bool, ListView_GetSubItemRect,(HWND h, int item, int subitem, int code, RECT *r))
SWELL_API_DEFINE(void, ListView_SetImageList,(HWND h, HIMAGELIST imagelist, int which)) 
SWELL_API_DEFINE(int, ListView_HitTest,(HWND h, LVHITTESTINFO *pinf))
SWELL_API_DEFINE(int, ListView_SubItemHitTest,(HWND h, LVHITTESTINFO *pinf))
SWELL_API_DEFINE(void, ListView_GetItemText,(HWND hwnd, int item, int subitem, char *text, int textmax))
SWELL_API_DEFINE(void, ListView_SortItems,(HWND hwnd, PFNLVCOMPARE compf, LPARAM parm))
SWELL_API_DEFINE(bool, ListView_GetItemRect,(HWND h, int item, RECT *r, int code))
SWELL_API_DEFINE(bool, ListView_Scroll,(HWND h, int xscroll, int yscroll))

#ifndef ImageList_Create
#define ImageList_Create(x,y,a,b,c) ImageList_CreateEx();
#endif
SWELL_API_DEFINE(HIMAGELIST, ImageList_CreateEx,())
SWELL_API_DEFINE(void, ImageList_ReplaceIcon,(HIMAGELIST list, int offset, HICON image))
SWELL_API_DEFINE(void, ImageList_Destroy, (HIMAGELIST))
/*
** TabCtrl api. 
*/
SWELL_API_DEFINE(int, TabCtrl_GetItemCount,(HWND hwnd))
SWELL_API_DEFINE(BOOL, TabCtrl_DeleteItem,(HWND hwnd, int idx))
SWELL_API_DEFINE(int, TabCtrl_InsertItem,(HWND hwnd, int idx, TCITEM *item))
SWELL_API_DEFINE(int, TabCtrl_SetCurSel,(HWND hwnd, int idx))
SWELL_API_DEFINE(int, TabCtrl_GetCurSel,(HWND hwnd))
SWELL_API_DEFINE(BOOL, TabCtrl_AdjustRect, (HWND hwnd, BOOL fLarger, RECT *r))

/*
** TreeView
*/

SWELL_API_DEFINE(HTREEITEM, TreeView_InsertItem, (HWND hwnd, TV_INSERTSTRUCT *ins)) 
SWELL_API_DEFINE(BOOL, TreeView_Expand,(HWND hwnd, HTREEITEM item, UINT flag))
SWELL_API_DEFINE(HTREEITEM, TreeView_GetSelection,(HWND hwnd))
SWELL_API_DEFINE(void, TreeView_DeleteItem,(HWND hwnd, HTREEITEM item))
SWELL_API_DEFINE(void, TreeView_SelectItem,(HWND hwnd, HTREEITEM item))
SWELL_API_DEFINE(BOOL, TreeView_GetItem,(HWND hwnd, LPTVITEM pitem))
SWELL_API_DEFINE(BOOL, TreeView_SetItem,(HWND hwnd, LPTVITEM pitem))
SWELL_API_DEFINE(HTREEITEM, TreeView_HitTest, (HWND hwnd, TVHITTESTINFO *hti))
SWELL_API_DEFINE(BOOL, TreeView_SetIndent,(HWND hwnd, int indent))

SWELL_API_DEFINE(HTREEITEM, TreeView_GetChild, (HWND hwnd, HTREEITEM item))
SWELL_API_DEFINE(HTREEITEM, TreeView_GetNextSibling, (HWND hwnd, HTREEITEM item))
SWELL_API_DEFINE(HTREEITEM, TreeView_GetRoot, (HWND hwnd))


/*
** These are deprecated functions for launching a modal window but still running
** your own code. In general use DialogBox with a timer if needed instead.
*/
SWELL_API_DEFINE(void *, SWELL_ModalWindowStart,(HWND hwnd))
SWELL_API_DEFINE(bool, SWELL_ModalWindowRun,(void *ctx, int *ret)) // returns false and puts retval in *ret when done
SWELL_API_DEFINE(void, SWELL_ModalWindowEnd,(void *ctx))
SWELL_API_DEFINE(void, SWELL_CloseWindow,(HWND hwnd))


/*
** Menu functions
** HMENU is a NSMenu *.
*/
SWELL_API_DEFINE(HMENU, CreatePopupMenu,())
SWELL_API_DEFINE(HMENU, CreatePopupMenuEx,(const char *title))
SWELL_API_DEFINE(void, DestroyMenu,(HMENU hMenu))
SWELL_API_DEFINE(int, AddMenuItem,(HMENU hMenu, int pos, const char *name, int tagid))
SWELL_API_DEFINE(HMENU, GetSubMenu,(HMENU hMenu, int pos))
SWELL_API_DEFINE(int, GetMenuItemCount,(HMENU hMenu))
SWELL_API_DEFINE(int, GetMenuItemID,(HMENU hMenu, int pos))
SWELL_API_DEFINE(bool, SetMenuItemModifier,(HMENU hMenu, int idx, int flag, int code, unsigned int mask))
SWELL_API_DEFINE(bool, SetMenuItemText,(HMENU hMenu, int idx, int flag, const char *text))
SWELL_API_DEFINE(bool, EnableMenuItem,(HMENU hMenu, int idx, int en))
SWELL_API_DEFINE(bool, DeleteMenu,(HMENU hMenu, int idx, int flag))
SWELL_API_DEFINE(bool, CheckMenuItem,(HMENU hMenu, int idx, int chk))
SWELL_API_DEFINE(void, InsertMenuItem,(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi))
SWELL_API_DEFINE(void,SWELL_InsertMenu,(HMENU menu, int pos, int flag, int idx, const char *str))
#ifdef InsertMenu
#undef InsertMenu
#endif
#define InsertMenu SWELL_InsertMenu

SWELL_API_DEFINE(BOOL, GetMenuItemInfo,(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi))
SWELL_API_DEFINE(BOOL, SetMenuItemInfo,(HMENU hMenu, int pos, BOOL byPos, MENUITEMINFO *mi))
SWELL_API_DEFINE(void, DrawMenuBar,(HWND))



/*
** LoadMenu()
**  Loads a menu created with SWELL_DEFINE_MENU_RESOURCE_BEGIN(), see swell-menugen.h
**  Notes: the hinst parameter is ignored, the menu must have been defined in the same 
**  APP or DYLIB as the LoadMenu call. If you wish to load a menu from another module, 
**  you should somehow get its SWELL_curmodule_menuresource_head and pass it to SWELL_LoadMenu
**  directly.
*/
#ifndef LoadMenu
#define LoadMenu(hinst,resid) SWELL_LoadMenu(SWELL_curmodule_menuresource_head,(resid))
#endif
SWELL_API_DEFINE(HMENU, SWELL_LoadMenu,(struct SWELL_MenuResourceIndex *head, const char *resid))

/*
** TrackPopupMenu
** Notes: the rectangle and many flags are ignored, but TPM_NONOTIFY is used.
** It always returns the command selected, even if TPM_RETURNCMD is not specified.
*/
SWELL_API_DEFINE(int, TrackPopupMenu,(HMENU hMenu, int flags, int xpos, int ypos, int resvd, HWND hwnd, const RECT *r))

/* 
** SWELL_SetMenuDestination: set the action destination for all items in a menu 
** Notes:
**   TrackPopupMenu and SetMenu use this internally, but it may be useful.
*/
SWELL_API_DEFINE(void, SWELL_SetMenuDestination,(HMENU menu, HWND hwnd))

/*
** SWELL_DuplicateMenu:
** Copies an entire menu.
*/
SWELL_API_DEFINE(HMENU, SWELL_DuplicateMenu,(HMENU menu))  

/*
** SetMenu()/GetMenu()
** Notes: These work on SWELL created NSWindows, or objective C objects that respond to
** swellSetMenu:(HMENU) and swellGetMenu. 
** Setting these values doesnt mean anything, except that the SWELL windows will automatically
** set the application menu via NSApp setMainMenu: when activated.
** 
*/
SWELL_API_DEFINE(BOOL, SetMenu,(HWND hwnd, HMENU menu))
SWELL_API_DEFINE(HMENU, GetMenu,(HWND hwnd))

/*
** SWELL_SetDefaultWindowMenu()/SWELL_GetDefaultWindowMenu()
** these set an internal flag for the default window menu, which will be set 
** when switching to a window that has no menu set. Set this to your application's
** main menu.
*/
SWELL_API_DEFINE(HMENU, SWELL_GetDefaultWindowMenu,())
SWELL_API_DEFINE(void, SWELL_SetDefaultWindowMenu,(HMENU))
SWELL_API_DEFINE(HMENU, SWELL_GetDefaultModalWindowMenu,())
SWELL_API_DEFINE(void, SWELL_SetDefaultModalWindowMenu,(HMENU))
SWELL_API_DEFINE(HMENU, SWELL_GetCurrentMenu,())
SWELL_API_DEFINE(void, SWELL_SetCurrentMenu,(HMENU))



/* 
** SWELL dialog box/control/window/child dialog/etc creation
** DialogBox(), DialogBoxParam(), CreateDialog(), and CreateDialogParam()
**
** Notes:
** hInstance parameters are ignored. If you wish to load a dialog resource from another
** module (DYLIB), you should get its SWELL_curmodule_dialogresource_head via your own 
** mechanism and pass it as the first parameter of SWELL_DialogBox or whichever API.
** 
** If you are using CreateDialog() and creating a child window, you can use a resource ID of 
** 0, which creates an opaque child window. Instead of passing a DLGPROC, you should pass a 
** routine that retuns LRESULT (and cast it to DLGPROC).
** 
*/

#ifndef DialogBox
#define DialogBox(hinst, resid, par, dlgproc) SWELL_DialogBox(SWELL_curmodule_dialogresource_head,(resid),par,dlgproc,0)
#define DialogBoxParam(hinst, resid, par, dlgproc, param) SWELL_DialogBox(SWELL_curmodule_dialogresource_head,(resid),par,dlgproc,param)
#define CreateDialog(hinst,resid,par,dlgproc) SWELL_CreateDialog(SWELL_curmodule_dialogresource_head,(resid),par,dlgproc,0)
#define CreateDialogParam(hinst,resid,par,dlgproc,param) SWELL_CreateDialog(SWELL_curmodule_dialogresource_head,(resid),par,dlgproc,param)
#endif
SWELL_API_DEFINE(int, SWELL_DialogBox,(struct SWELL_DialogResourceIndex *reshead, const char *resid, HWND parent,  DLGPROC dlgproc, LPARAM param))  
SWELL_API_DEFINE(HWND, SWELL_CreateDialog,(struct SWELL_DialogResourceIndex *reshead, const char *resid, HWND parent, DLGPROC dlgproc, LPARAM param))


/*
** SWELL_RegisterCustomControlCreator(), SWELL_UnregisterCustomControlCreator()
** Notes:
** Pass these a callback function that can create custom controls based on classname.
** Todo: document.
*/

SWELL_API_DEFINE(void, SWELL_RegisterCustomControlCreator,(SWELL_ControlCreatorProc proc))
SWELL_API_DEFINE(void, SWELL_UnregisterCustomControlCreator,(SWELL_ControlCreatorProc proc))

/*
** DefWindowProc(). 
** Notes: Doesnt do much but call it anyway from any child windows created with CreateDialog 
** and a 0 resource-id window proc.
*/
SWELL_API_DEFINE(LRESULT, DefWindowProc,(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam))
                 
/*
** EndDialog():
** Notes: _ONLY_ use on a dialog created with DialogBox(). Will do nothing on other dialogs.
*/
SWELL_API_DEFINE(void, EndDialog,(HWND, int))            


SWELL_API_DEFINE(int,SWELL_GetDefaultButtonID,(HWND hwndDlg, bool onlyIfEnabled))


/*
** SendMessage()
** Notes:
**   LIMITATION - SendMessage should only be used from the same thread that the window/view
**   was created in. Cross-thread use SHOULD BE AVOIDED. It may work, but it may blow up.
**   PostMessage  (below) can be used in certain instances for asynchronous notifications.
** 
** If the hwnd supports onSwellMessage:p1:p2: then the message is sent via this.
** Alternatively, buttons created via the dialog interface support BM_GETIMAGE/BM_SETIMAGE
** NSPopUpButton and NSComboBox controls support CB_*
** NSSlider controls support TBM_*
** If the receiver is a view and none of these work, the message goes to the window's onSwellMessage, if any
** If the receiver is a window and none of these work, the message goes to the window's contentview's onSwellMessage, if any
**
*/
SWELL_API_DEFINE(LRESULT, SendMessage,(HWND, UINT, WPARAM, LPARAM))  
#ifndef SendDlgItemMessage                                       
#define SendDlgItemMessage(hwnd,idx,msg,wparam,lparam) SendMessage(GetDlgItem(hwnd,idx),msg,wparam,lparam)
#endif

SWELL_API_DEFINE(void,SWELL_BroadcastMessage,(UINT, WPARAM, LPARAM))

/*
** PostMessage()
** Notes:
**   Queues a message into the application message queue. Note that you should only ever
**   send messages to destinations that were created from the main thread. They will be 
**   processed later from a timer (in the main thread).
** When a window is destroyed any outstanding messages will be discarded for it.
*/
SWELL_API_DEFINE(BOOL, PostMessage,(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam))

/*
** SWELL_MessageQueue_Flush():
** Notes:
** Processes all messages in the message queue. ONLY call from the main thread.
*/
SWELL_API_DEFINE(void, SWELL_MessageQueue_Flush,())

/*
** SWELL_MessageQueue_Clear():
** Notes:
** Discards all messages from the message queue if h is NULL, otherwise discards all messages
** to h.
*/
SWELL_API_DEFINE(void, SWELL_MessageQueue_Clear,(HWND h))



/*
** keyboard/mouse support
*/

/*
** SWELL_MacKeyToWindowsKey()
** Pass a keyboard NSEvent *, and it will return a windows VK_ keycode (or ascii), and set flags, 
** including (possibly) FSHIFT, FCONTROL (apple key), FALT, and FVIRTKEY. The ctrl key is not checked,
** as SWELL generally encourages this to be used soley for a right mouse button (as modifier).
*/
#ifdef SWELL_TARGET_OSX
SWELL_API_DEFINE(int, SWELL_MacKeyToWindowsKey,(void *nsevent, int *flags))
#endif
SWELL_API_DEFINE(int,SWELL_KeyToASCII,(int wParam, int lParam, int *newflags))


/*
** GetAsyncKeyState()
** Notes: only supports MK_LBUTTON, MK_RBUTTON, MK_MBUTTON, VK_SHIFT, VK_MENU, and VK_CONTROL (apple key) for now.
*/
SWELL_API_DEFINE(WORD, GetAsyncKeyState,(int key))

/*
** GetCursorPos(), GetMessagePos()
** Notes: GetMessagePos() currently returns the same coordinates as GetCursorPos(),
** this needs to be fixed.
*/
SWELL_API_DEFINE(void, GetCursorPos,(POINT *pt))
SWELL_API_DEFINE(DWORD, GetMessagePos,())

/*
** LoadCursor(). 
** Notes: hinstance parameter ignored, currently only supports loading some of the predefined values.
** (IDC_SIZEALL etc). If it succeeds value is a NSCursor *
*/
SWELL_API_DEFINE(HCURSOR, SWELL_LoadCursor,(const char *idx))
#ifndef LoadCursor
#define LoadCursor(a,x) SWELL_LoadCursor(x)
#endif

/*
** SetCursor()
** Sets a cursor as active (can be HCURSOR or NSCursor * cast as such).
*/
#ifdef SetCursor
#undef SetCursor
#endif
#define SetCursor(x) SWELL_SetCursor(x)
SWELL_API_DEFINE(void, SWELL_SetCursor,(HCURSOR curs))


#ifdef GetCursor
#undef GetCursor
#endif
#define GetCursor SWELL_GetCursor

#ifdef ShowCursor
#undef ShowCursor
#endif
#define ShowCursor SWELL_ShowCursor

#ifdef SetCursorPos
#undef SetCursorPos
#endif
#define SetCursorPos SWELL_SetCursorPos

#ifdef ScrollWindowEx
#undef ScrollWindowEx
#endif
#define ScrollWindowEx(a,b,c,d,e,f,g,h) ScrollWindow(a,b,c,d,e)



/*
** GetCursor() gets the actual system cursor,
** SWELL_GetLastSetCursor() gets the last cursor set via SWELL (if they differ than some other window must have changed the cursor)
*/
SWELL_API_DEFINE(HCURSOR, SWELL_GetCursor,())
SWELL_API_DEFINE(HCURSOR, SWELL_GetLastSetCursor,())

SWELL_API_DEFINE(bool, SWELL_IsCursorVisible, ())
SWELL_API_DEFINE(int, SWELL_ShowCursor, (BOOL bShow))
SWELL_API_DEFINE(BOOL, SWELL_SetCursorPos, (int X, int Y))

/*
** SWELL_GetViewPort
** Gets screen information, for the screen that contains sourcerect. if wantWork is set
** it excluses the menu bar etc.
*/
SWELL_API_DEFINE(void, SWELL_GetViewPort,(RECT *r, RECT *sourcerect, bool wantWork))

/*
** Clipboard API emulation
** Notes: setting multiple types may not work right
** 
*/
SWELL_API_DEFINE(bool, OpenClipboard,(HWND hwndDlg))
SWELL_API_DEFINE(void, CloseClipboard,())
SWELL_API_DEFINE(HANDLE, GetClipboardData,(UINT type))

SWELL_API_DEFINE(void, EmptyClipboard,())
SWELL_API_DEFINE(void, SetClipboardData,(UINT type, HANDLE h))
SWELL_API_DEFINE(UINT, RegisterClipboardFormat,(const char *desc))
SWELL_API_DEFINE(UINT, EnumClipboardFormats,(UINT lastfmt))

#ifndef CF_TEXT
#define CF_TEXT (RegisterClipboardFormat("SWELL__CF_TEXT"))
#endif

/*
** GlobalAlloc*() 
** These are only currently used by the clipboard system,
** but should work normally. 
*/

SWELL_API_DEFINE(HANDLE, GlobalAlloc,(int flags, int sz))
SWELL_API_DEFINE(void *, GlobalLock,(HANDLE h))
SWELL_API_DEFINE(int, GlobalSize,(HANDLE h))
SWELL_API_DEFINE(void, GlobalUnlock,(HANDLE h))
SWELL_API_DEFINE(void, GlobalFree,(HANDLE h))



SWELL_API_DEFINE(HANDLE,CreateThread,(void *TA, DWORD stackSize, DWORD (*ThreadProc)(LPVOID), LPVOID parm, DWORD cf, DWORD *tidOut))
SWELL_API_DEFINE(HANDLE,CreateEvent,(void *SA, BOOL manualReset, BOOL initialSig, const char *ignored))
SWELL_API_DEFINE(HANDLE,CreateEventAsSocket,(void *SA, BOOL manualReset, BOOL initialSig, const char *ignored))

SWELL_API_DEFINE(DWORD,GetCurrentThreadId,())
SWELL_API_DEFINE(DWORD,WaitForSingleObject,(HANDLE hand, DWORD msTO))
SWELL_API_DEFINE(DWORD,WaitForAnySocketObject,(int numObjs, HANDLE *objs, DWORD msTO)) // waits for any number of socket objects
SWELL_API_DEFINE(BOOL,CloseHandle,(HANDLE hand))
SWELL_API_DEFINE(BOOL,SetThreadPriority,(HANDLE evt, int prio))
SWELL_API_DEFINE(BOOL,SetEvent,(HANDLE evt))
SWELL_API_DEFINE(BOOL,ResetEvent,(HANDLE evt))

#ifdef SWELL_TARGET_OSX
SWELL_API_DEFINE(void,SWELL_EnsureMultithreadedCocoa,())
SWELL_API_DEFINE(void *, SWELL_InitAutoRelease,())
SWELL_API_DEFINE(void, SWELL_QuitAutoRelease,(void *p))
SWELL_API_DEFINE(HANDLE,SWELL_CreateProcess,(const char *exe, int nparams, const char **params))
#endif


SWELL_API_DEFINE(HINSTANCE,LoadLibraryGlobals,(const char *fileName, bool symbolsAsGlobals))
SWELL_API_DEFINE(HINSTANCE,LoadLibrary,(const char *fileName))
SWELL_API_DEFINE(void *,GetProcAddress,(HINSTANCE hInst, const char *procName))
SWELL_API_DEFINE(BOOL,FreeLibrary,(HINSTANCE hInst))

/*
** GDI functions.
** Everything should be all hunky dory, your windows may get WM_PAINT, call 
** GetDC()/ReleaseDC(), etc.
**
** Or, there are these helper functions:
*/


/*
** SWELL_CreateMemContext()
** Creates a memory context (that you can get the bits for, below)
** hdc is currently ignored.
*/
SWELL_API_DEFINE(HDC, SWELL_CreateMemContext,(HDC hdc, int w, int h))

/*
** SWELL_DeleteGfxContext()
** Deletes a context created with SWELL_CreateMemContext() (or the internal SWELL_CreateGfxContext)
*/
SWELL_API_DEFINE(void, SWELL_DeleteGfxContext,(HDC))

/*
** SWELL_GetCtxGC()
** Returns the CGContextRef of a HDC
*/
SWELL_API_DEFINE(void *, SWELL_GetCtxGC,(HDC ctx))


/*
** SWELL_GetCtxFrameBuffer()
** Gets the framebuffer of a memory context. NULL if none available.
*/
SWELL_API_DEFINE(void *, SWELL_GetCtxFrameBuffer,(HDC ctx))



/* 
** Some utility functions for pushing, setting, and popping the clip region. 
*/
SWELL_API_DEFINE(void, SWELL_PushClipRegion,(HDC ctx))
SWELL_API_DEFINE(void, SWELL_SetClipRegion,(HDC ctx, RECT *r))
SWELL_API_DEFINE(void, SWELL_PopClipRegion,(HDC ctx))


/* 
** GDI emulation functions
** todo: document
*/

SWELL_API_DEFINE(HFONT, CreateFontIndirect,(LOGFONT *))
SWELL_API_DEFINE(HFONT, CreateFont,(int lfHeight, int lfWidth, int lfEscapement, int lfOrientation, int lfWeight, char lfItalic, 
  char lfUnderline, char lfStrikeOut, char lfCharSet, char lfOutPrecision, char lfClipPrecision, 
         char lfQuality, char lfPitchAndFamily, const char *lfFaceName))

SWELL_API_DEFINE(HPEN, CreatePen,(int attr, int wid, int col))
SWELL_API_DEFINE(HBRUSH, CreateSolidBrush,(int col))
SWELL_API_DEFINE(HPEN, CreatePenAlpha,(int attr, int wid, int col, float alpha))
SWELL_API_DEFINE(HBRUSH, CreateSolidBrushAlpha,(int col, float alpha))
SWELL_API_DEFINE(HGDIOBJ, SelectObject,(HDC ctx, HGDIOBJ pen))
SWELL_API_DEFINE(HGDIOBJ, GetStockObject,(int wh))
SWELL_API_DEFINE(void, DeleteObject,(HGDIOBJ))
#ifndef DestroyIcon
#define DestroyIcon(x) DeleteObject(x)
#endif

#ifdef LineTo
#undef LineTo
#endif
#ifdef SetPixel
#undef SetPixel
#endif
#ifdef FillRect
#undef FillRect
#endif
#ifdef DrawText
#undef DrawText
#endif
#ifdef Polygon
#undef Polygon
#endif

#define DrawText SWELL_DrawText
#define FillRect SWELL_FillRect
#define LineTo SWELL_LineTo
#define SetPixel SWELL_SetPixel
#define Polygon(a,b,c) SWELL_Polygon(a,b,c)

SWELL_API_DEFINE(void, SWELL_FillRect,(HDC ctx, RECT *r, HBRUSH br))
SWELL_API_DEFINE(void, Rectangle,(HDC ctx, int l, int t, int r, int b))
SWELL_API_DEFINE(void, Ellipse,(HDC ctx, int l, int t, int r, int b))
SWELL_API_DEFINE(void, SWELL_Polygon,(HDC ctx, POINT *pts, int npts))
SWELL_API_DEFINE(void, MoveToEx,(HDC ctx, int x, int y, POINT *op))
SWELL_API_DEFINE(void, LineTo,(HDC ctx, int x, int y))
SWELL_API_DEFINE(void, SetPixel,(HDC ctx, int x, int y, int c))
SWELL_API_DEFINE(void, PolyBezierTo,(HDC ctx, POINT *pts, int np))
SWELL_API_DEFINE(int, SWELL_DrawText,(HDC ctx, const char *buf, int len, RECT *r, int align))
SWELL_API_DEFINE(void, SetTextColor,(HDC ctx, int col))
SWELL_API_DEFINE(void, SetBkColor,(HDC ctx, int col))
SWELL_API_DEFINE(void, SetBkMode,(HDC ctx, int col))

SWELL_API_DEFINE(void, RoundRect,(HDC ctx, int x, int y, int x2, int y2, int xrnd, int yrnd))
SWELL_API_DEFINE(void, PolyPolyline,(HDC ctx, POINT *pts, DWORD *cnts, int nseg))
SWELL_API_DEFINE(BOOL, GetTextMetrics,(HDC ctx, TEXTMETRIC *tm))
#ifdef SWELL_TARGET_OSX
SWELL_API_DEFINE(void *, GetNSImageFromHICON,(HICON))
#endif
SWELL_API_DEFINE(BOOL, GetObject, (HICON icon, int bmsz, void *_bm))
SWELL_API_DEFINE(HICON, LoadNamedImage,(const char *name, bool alphaFromMask))
SWELL_API_DEFINE(void, DrawImageInRect,(HDC ctx, HICON img, RECT *r))
SWELL_API_DEFINE(void, BitBlt,(HDC hdcOut, int x, int y, int w, int h, HDC hdcIn, int xin, int yin, int mode))
SWELL_API_DEFINE(void, BitBltAlpha,(HDC hdcOut, int x, int y, int w, int h, HDC hdcIn, int xin, int yin, int mode, bool useAlphaChannel, float opacity))
SWELL_API_DEFINE(void, BitBltAlphaFromMem,(HDC hdcOut, int x, int y, int w, int h, void *inbuf, int inbuf_span, int inbuf_h, int xin, int yin, int mode, bool useAlphaChannel, float opacity))
SWELL_API_DEFINE(void, StretchBlt,(HDC hdcOut, int x, int y, int w, int h, HDC hdcIn, int xin, int yin, int srcw, int srch, int mode))
SWELL_API_DEFINE(int, GetSysColor,(int idx))
SWELL_API_DEFINE(HBITMAP, CreateBitmap,(int width, int height, int numplanes, int bitsperpixel, unsigned char* bits))

SWELL_API_DEFINE(void, SetOpaque, (HWND h, bool isopaque))
#ifdef SWELL_TARGET_OSX
SWELL_API_DEFINE(void, SWELL_SetViewGL, (HWND h, bool wantGL))
SWELL_API_DEFINE(bool, SWELL_GetViewGL, (HWND h))
SWELL_API_DEFINE(bool, SWELL_SetGLContextToView, (HWND h)) // sets GL context to that view, returns TRUE if successs (use NULL to clear GL context)
#endif

SWELL_API_DEFINE(HDC, BeginPaint,(HWND, PAINTSTRUCT *))
SWELL_API_DEFINE(BOOL, EndPaint,(HWND, PAINTSTRUCT *))

SWELL_API_DEFINE(HDC, GetDC,(HWND)) // use these sparingly! they kinda work but shouldnt be overused!!
SWELL_API_DEFINE(HDC, GetWindowDC,(HWND)) 
SWELL_API_DEFINE(void, ReleaseDC,(HWND, HDC))
            
SWELL_API_DEFINE(void, SWELL_FillDialogBackground,(HDC hdc, RECT *r, int level))

SWELL_API_DEFINE(int, GetSystemMetrics, (int))

SWELL_API_DEFINE(BOOL, DragQueryPoint,(HDROP,LPPOINT))
SWELL_API_DEFINE(void, DragFinish,(HDROP))
SWELL_API_DEFINE(UINT, DragQueryFile,(HDROP,UINT,char *,UINT))

// source drag/drop - callback is source implementing "create dropped files at droppath"
SWELL_API_DEFINE(void, SWELL_InitiateDragDrop, (HWND, RECT* srcrect, const char* srcfn, void (*callback)(const char* droppath)))
SWELL_API_DEFINE(void,SWELL_InitiateDragDropOfFileList,(HWND, RECT *srcrect, const char **srclist, int srccount, HICON icon))
SWELL_API_DEFINE(void, SWELL_FinishDragDrop, ())  // cancels any outstanding InitiateDragDrop



// r=NULL to "free" handle
// otherwise r is in hwndPar coordinates
SWELL_API_DEFINE(void,SWELL_DrawFocusRect,(HWND hwndPar, RECT *rct, void **handle))


#ifdef SWELL_TARGET_OSX
SWELL_API_DEFINE(void,SWELL_SetWindowRepre,(HWND hwnd, const char *fn, bool isDirty)) // sets the represented file and edited state
SWELL_API_DEFINE(void,SWELL_PostQuitMessage,(void *sender))
#endif

/*
** Functions used by swell-dlggen.h and swell-menugen.h
** No need to really dig into these unless you're working on swell or debugging..
*/

SWELL_API_DEFINE(void, SWELL_MakeSetCurParms,(float xscale, float yscale, float xtrans, float ytrans, HWND parent, bool doauto, bool dosizetofit))

SWELL_API_DEFINE(HWND, SWELL_MakeButton,(int def, const char *label, int idx, int x, int y, int w, int h, int flags))
SWELL_API_DEFINE(HWND, SWELL_MakeEditField,(int idx, int x, int y, int w, int h, int flags))
SWELL_API_DEFINE(HWND, SWELL_MakeLabel,(int align, const char *label, int idx, int x, int y, int w, int h, int flags))
SWELL_API_DEFINE(HWND, SWELL_MakeControl,(const char *cname, int idx, const char *classname, int style, int x, int y, int w, int h, int exstyle))
SWELL_API_DEFINE(HWND, SWELL_MakeCombo,(int idx, int x, int y, int w, int h, int flags))
SWELL_API_DEFINE(HWND, SWELL_MakeGroupBox,(const char *name, int idx, int x, int y, int w, int h, int style))
SWELL_API_DEFINE(HWND, SWELL_MakeCheckBox,(const char *name, int idx, int x, int y, int w, int h, int flags))
SWELL_API_DEFINE(HWND, SWELL_MakeListBox,(int idx, int x, int y, int w, int h, int styles))

SWELL_API_DEFINE(void, SWELL_Menu_AddMenuItem,(HMENU hMenu, const char *name, int idx, int flags))



SWELL_API_DEFINE(unsigned int, _controlfp,(unsigned int flag, unsigned int mask))



#endif // _WDL_SWELL_H_API_DEFINED_


#ifndef SWELL_PROVIDED_BY_APP
#ifndef _WDL_SWELL_H_UTIL_DEFINED_
#define _WDL_SWELL_H_UTIL_DEFINED_

// these should never be called directly!!! put SWELL_POSTMESSAGE_DELEGATE_IMPL in your nsapp delegate, and call SWELL_POSTMESSAGE_INIT at some point from there too
void SWELL_Internal_PostMessage_Init();
BOOL SWELL_Internal_PostMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
void SWELL_Internal_PMQ_ClearAllMessages(HWND hwnd);
                 
#define SWELL_POSTMESSAGE_DELEGATE_IMPL \
                 -(bool)swellPostMessage:(HWND)dest msg:(int)message wp:(WPARAM)wParam lp:(LPARAM)lParam { \
                   return SWELL_Internal_PostMessage(dest,message,wParam,lParam); \
                 } \
                 -(void)swellPostMessageClearQ:(HWND)dest { \
                   SWELL_Internal_PMQ_ClearAllMessages(dest); \
                 } \
                 -(void)swellPostMessageTick:(id)sender { \
                   SWELL_MessageQueue_Flush(); \
                 } 
                 
#define SWELL_POSTMESSAGE_INIT SWELL_Internal_PostMessage_Init();


// if you use this then include swell-appstub.mm in your project
#define SWELL_APPAPI_DELEGATE_IMPL \
                -(void *)swellGetAPPAPIFunc { \
                    void *SWELLAPI_GetFunc(const char *name); \
                    return (void*)SWELLAPI_GetFunc; \
                }

#endif // _WDL_SWELL_H_UTIL_DEFINED_
#endif // !SWELL_PROVIDED_BY_APP

#endif // !_WIN32


#ifndef SWELL_TARGET_OSX

#ifndef SWELL_CB_InsertString

#define SWELL_CB_InsertString(hwnd, idx, pos, str) SendDlgItemMessage(hwnd,idx,CB_INSERTSTRING,(pos),(LPARAM)(str))
#define SWELL_CB_AddString(hwnd, idx, str) SendDlgItemMessage(hwnd,idx,CB_ADDSTRING,0,(LPARAM)(str))
#define SWELL_CB_SetCurSel(hwnd,idx,val) SendDlgItemMessage(hwnd,idx,CB_SETCURSEL,(WPARAM)(val),0)
#define SWELL_CB_GetNumItems(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_GETCOUNT,0,0)
#define SWELL_CB_GetCurSel(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_GETCURSEL,0,0)
#define SWELL_CB_SetItemData(hwnd,idx,item,val) SendDlgItemMessage(hwnd,idx,CB_SETITEMDATA,(item),(val))
#define SWELL_CB_GetItemData(hwnd,idx,item) SendDlgItemMessage(hwnd,idx,CB_GETITEMDATA,(item),0)
#define SWELL_CB_GetItemText(hwnd,idx,item,buf,bufsz) SendDlgItemMessage(hwnd,idx,CB_GETLBTEXT,(item),(LPARAM)(buf))
#define SWELL_CB_Empty(hwnd,idx) SendDlgItemMessage(hwnd,idx,CB_RESETCONTENT,0,0)
#define SWELL_CB_DeleteString(hwnd,idx,str) SendDlgItemMessage(hwnd,idx,CB_DELETESTRING,str,0)

#define SWELL_TB_SetPos(hwnd, idx, pos) SendDlgItemMessage(hwnd,idx, TBM_SETPOS,TRUE,(pos))
#define SWELL_TB_SetRange(hwnd, idx, low, hi) SendDlgItemMessage(hwnd,idx,TBM_SETRANGE,TRUE,(LPARAM)MAKELONG((low),(hi)))
#define SWELL_TB_GetPos(hwnd, idx) SendDlgItemMessage(hwnd,idx,TBM_GETPOS,0,0)
#define SWELL_TB_SetTic(hwnd, idx, pos) SendDlgItemMessage(hwnd,idx,TBM_SETTIC,0,(pos))

#endif

#endif// !SWELL_TARGET_OSX




#ifndef WDL_GDP_CTX                // stupid GDP compatibility layer, deprecated


#define WDL_GDP_CTX HDC
#define WDL_GDP_PEN HPEN
#define WDL_GDP_BRUSH HBRUSH
#define WDL_GDP_CreatePen(col, wid) (WDL_GDP_PEN)CreatePen(PS_SOLID,(wid),(col))
#define WDL_GDP_DeletePen(pen) DeleteObject((HGDIOBJ)(pen))
#define WDL_GDP_SetPen(ctx, pen) ((WDL_GDP_PEN)SelectObject(ctx,(HGDIOBJ)(pen)))
#define WDL_GDP_SetBrush(ctx, brush) ((WDL_GDP_BRUSH)SelectObject(ctx,(HGDIOBJ)(brush)))
#define WDL_GDP_CreateBrush(col) (WDL_GDP_BRUSH)CreateSolidBrush(col)
#define WDL_GDP_DeleteBrush(brush) DeleteObject((HGDIOBJ)(brush))
#define WDL_GDP_FillRectWithBrush(hdc,r,br) FillRect(hdc,r,(HBRUSH)(br))
#define WDL_GDP_Rectangle(hdc,l,t,r,b) Rectangle(hdc,l,t,r,b)
#define WDL_GDP_Polygon(hdc,pts,n) Polygon(hdc,pts,n)
#define WDL_GDP_MoveToEx(hdc,x,y,op) MoveToEx(hdc,x,y,op)
#define WDL_GDP_LineTo(hdc,x,y) LineTo(hdc,x,y)
#define WDL_GDP_PutPixel(hdc,x,y,c) SetPixel(hdc,x,y,c)
#define WDL_GDP_PolyBezierTo(hdc,p,np) PolyBezierTo(hdc,p,np)

#define SWELL_SyncCtxFrameBuffer(x) // no longer used

#endif

#if defined(_WIN32) && !defined(LoadLibraryGlobals)
#define LoadLibraryGlobals(a,b) LoadLibrary(a)
#endif


#ifndef SWELL_APP_PREFIX
#define SWELL_APP_PREFIX SWELL_
#endif
